#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
#endregion

namespace GroundhogLearning.GameKit
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_TRANSFORMS + "Reset Transform")]
    public class ResetTransform : MonoBehaviour
    {
        #region Variables

        [Header("Configuration")]
        [SerializeField, Tooltip("If true, the transform resets automatically after the delay when the scene starts.")]
        private bool _autoReset = false;

        [SerializeField, Tooltip("If true, the position will be reset to its initial value.")]
        private bool _resetPosition = true;

        [SerializeField, Tooltip("If true, the rotation will be reset to its initial value.")]
        private bool _resetRotation = true;

        [SerializeField, Tooltip("If true, the scale will be reset to its initial value.")]
        private bool _resetScale = true;

        [SerializeField, Tooltip("Time delay (in seconds) before the reset is applied.")]
        private float _resetDelay = 0f;

        private Vector3 _initialPosition;
        private Quaternion _initialRotation;
        private Vector3 _initialScale;

        #endregion


        private void Awake()
        {
            _initialPosition = transform.position;
            _initialRotation = transform.rotation;
            _initialScale = transform.localScale;

            if (_autoReset)
            {
                Invoke(nameof(ResetToInitialValues), _resetDelay);
            }
        }


        /// <summary>
        /// Resets the transform to its stored initial values after the configured delay.
        /// </summary>
        public void ResetTransformNow()
        {
            if (_resetDelay <= 0f)
            {
                ResetToInitialValues();
            }
            else
            {
                Invoke(nameof(ResetToInitialValues), _resetDelay);
            }
        }

        private void ResetToInitialValues()
        {
            if (_resetPosition)
            {
                transform.position = _initialPosition;
            }

            if (_resetRotation)
            {
                transform.rotation = _initialRotation;
            }

            if (_resetScale)
            {
                transform.localScale = _initialScale;
            }
        }
    }
}
